// If JavaScript is enabled remove 'no-js' class and give 'js' class

jQuery('html').removeClass('no-js').addClass('js');



// When DOM is fully loaded

jQuery(document).ready(function($) {



	/* ---------------------------------------------------------------------- */

	/*	Portfolio Filter

	/* ---------------------------------------------------------------------- */



	(function() {



		var $container = $('#portfolio-items');



		if( $container.length ) {



			var $itemsFilter = $('.casual-list-filter');



			// Copy categories to item classes

			$('article', $container).each(function(i) {

				var $this = $(this);

				$this.addClass( $this.attr('data-categories') );

			});



			// Run Isotope when all images are fully loaded

			$(window).on('load', function() {



				$container.isotope({

					itemSelector : 'article',

					layoutMode   : 'fitRows'

				});



			});



			// Filter projects

			$itemsFilter.on('click', 'a', function(e) {

				var $this         = $(this),

					currentOption = $this.attr('data-categories');

				if( currentOption ) {

					if( currentOption !== '*' ) currentOption = currentOption.replace(currentOption, '.' + currentOption)

					$container.isotope({ filter : currentOption });

				}



				e.preventDefault();

			});



			$itemsFilter.on('mouseenter', function() {

				$(this).find('li').stop(true,true).slideLeftShow(300);

			});

			

			// Filter projects

			$itemsFilter.on('click', 'li', function(e) {

				var $this         = $(this);



				$itemsFilter.find('li').removeClass('selected');

				$this.addClass('selected');



				e.preventDefault();

			});



			$itemsFilter.find('li').first().addClass('selected');

			

		}



	})();



	/* end Portfolio Filter */



	











	



	/* ---------------------------------------------------------------------- */

	/*	PHP Widgets

	/* ---------------------------------------------------------------------- */



	(function() {



		function fetchFeed( url, element ) {



			element.html('<img src="img/loader.gif" height="11" width="16" alt="Loading..." />');



			$.ajax({

				url: url,

				dataType: 'html',

				timeout: 10000,

				type: 'GET',

				error:

					function(xhr, status, error) {

						element.html( 'An error occured: ' + error );

					},

				success:

					function(data, status, xhr) {

						element.html( data );

					}

			});

			

		}



	

	})();

		

	/* end PHP Widgets */



	



});



